const { registerBlockType } = wp.blocks;
const { MediaUpload, RichText, InspectorControls } = wp.blockEditor;
const { PanelBody, Button, TextControl } = wp.components;
const { createElement: el, Fragment } = wp.element;

registerBlockType("custom/marcador-futbol", {
    edit: ({ attributes, setAttributes }) => {
        const { equipoLocal, equipoVisitante, logoLocal, logoVisitante, golesLocal, golesVisitante, fecha, estado } = attributes;

        return el(
            Fragment,
            null,
            el(
                InspectorControls,
                null,
                el(
                    PanelBody,
                    { title: "Configuración del partido" },
                    el(TextControl, {
                        label: "Fecha y hora",
                        value: fecha,
                        onChange: (val) => setAttributes({ fecha: val })
                    }),
                    el(TextControl, {
                        label: "Estado",
                        value: estado,
                        onChange: (val) => setAttributes({ estado: val })
                    })
                )
            ),
            el("div", { className: "marcador" },
                el("div", { className: "marcador-header" }, fecha),
                el("div", { className: "marcador-body" },
                    // Local
                    el("div", { className: "equipo" },
                        el(MediaUpload, {
                            onSelect: (media) => setAttributes({ logoLocal: media.url }),
                            render: ({ open }) => el(Button, { onClick: open }, logoLocal ? el("img", { src: logoLocal, alt: equipoLocal }) : "Subir Logo")
                        }),
                        el(RichText, {
                            tagName: "h4",
                            value: equipoLocal,
                            onChange: (val) => setAttributes({ equipoLocal: val }),
                            placeholder: "Equipo Local"
                        })
                    ),
                    // Resultado
                    el("div", { className: "resultado" },
                        el(RichText, {
                            tagName: "span",
                            value: golesLocal,
                            onChange: (val) => setAttributes({ golesLocal: parseInt(val) || 0 }),
                            placeholder: "0"
                        }),
                        el("span", null, "-"),
                        el(RichText, {
                            tagName: "span",
                            value: golesVisitante,
                            onChange: (val) => setAttributes({ golesVisitante: parseInt(val) || 0 }),
                            placeholder: "0"
                        })
                    ),
                    // Visitante
                    el("div", { className: "equipo" },
                        el(MediaUpload, {
                            onSelect: (media) => setAttributes({ logoVisitante: media.url }),
                            render: ({ open }) => el(Button, { onClick: open }, logoVisitante ? el("img", { src: logoVisitante, alt: equipoVisitante }) : "Subir Logo")
                        }),
                        el(RichText, {
                            tagName: "h4",
                            value: equipoVisitante,
                            onChange: (val) => setAttributes({ equipoVisitante: val }),
                            placeholder: "Equipo Visitante"
                        })
                    )
                ),
                el("div", { className: "marcador-footer" }, estado)
            )
        );
    },

    save: ({ attributes }) => {
        const { equipoLocal, equipoVisitante, logoLocal, logoVisitante, golesLocal, golesVisitante, fecha, estado } = attributes;

        return el("div", { className: "marcador" },
            el("div", { className: "marcador-header" }, fecha),
            el("div", { className: "marcador-body" },
                el("div", { className: "equipo" },
                    logoLocal ? el("img", { src: logoLocal, alt: equipoLocal }) : null,
                    el("h4", null, equipoLocal)
                ),
                el("div", { className: "resultado" },
                    el("span", null, golesLocal),
                    el("span", null, "-"),
                    el("span", null, golesVisitante)
                ),
                el("div", { className: "equipo" },
                    logoVisitante ? el("img", { src: logoVisitante, alt: equipoVisitante }) : null,
                    el("h4", null, equipoVisitante)
                )
            ),
            el("div", { className: "marcador-footer" }, estado)
        );
    }
});
