<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Marcador_Elementor_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'marcador_futbol';
    }

    public function get_title() {
        return 'Marcador de Fútbol';
    }

    public function get_icon() {
        return 'eicon-sport';
    }

    public function get_categories() {
        return [ 'general' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => 'Configuración del partido',
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'equipo_local',
            [
                'label' => 'Equipo Local',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Local',
            ]
        );

        $this->add_control(
            'logo_local',
            [
                'label' => 'Logo Local',
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'goles_local',
            [
                'label' => 'Goles Local',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 0,
            ]
        );

        $this->add_control(
            'equipo_visitante',
            [
                'label' => 'Equipo Visitante',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Visitante',
            ]
        );

        $this->add_control(
            'logo_visitante',
            [
                'label' => 'Logo Visitante',
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'goles_visitante',
            [
                'label' => 'Goles Visitante',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 0,
            ]
        );

        $this->add_control(
            'estado',
            [
                'label' => 'Estado',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Finalizado',
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => 'Enlace',
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://tusitio.com',
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_external' => true,
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $this->add_render_attribute( 'wrapper', 'class', 'marcador-elementor' );

        // Si tiene enlace, usar <a>, si no <div>
        if ( ! empty( $settings['link']['url'] ) ) {
            $this->add_link_attributes( 'wrapper', $settings['link'] );
            echo '<a ' . $this->get_render_attribute_string( 'wrapper' ) . '>';
        } else {
            echo '<div ' . $this->get_render_attribute_string( 'wrapper' ) . '>';
        }
        ?>
            <div class="equipo">
                <?php if ( ! empty( $settings['logo_local']['url'] ) ) : ?>
                    <img src="<?php echo esc_url( $settings['logo_local']['url'] ); ?>" alt="<?php echo esc_attr( $settings['equipo_local'] ); ?>">
                <?php endif; ?>
                <h4><?php echo esc_html( $settings['equipo_local'] ); ?></h4>
            </div>
            <div class="resultado">
                <?php echo esc_html( $settings['goles_local'] ); ?> -
                <?php echo esc_html( $settings['goles_visitante'] ); ?>
                <div class="estado"><?php echo esc_html( $settings['estado'] ); ?></div>
            </div>
            <div class="equipo">
                <?php if ( ! empty( $settings['logo_visitante']['url'] ) ) : ?>
                    <img src="<?php echo esc_url( $settings['logo_visitante']['url'] ); ?>" alt="<?php echo esc_attr( $settings['equipo_visitante'] ); ?>">
                <?php endif; ?>
                <h4><?php echo esc_html( $settings['equipo_visitante'] ); ?></h4>
            </div>
        <?php
        if ( ! empty( $settings['link']['url'] ) ) {
            echo '</a>';
        } else {
            echo '</div>';
        }
    }
}
